<?php
/**
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/
if (!defined('_PS_VERSION_'))
    exit;

function upgrade_module_1_4($object, $install = false)
{
    // First uninstall old override
    try {
        $object->uninstallOldOverrides();
    } catch (Exception $e) {
        $object->add_error(sprintf(Tools::displayError('Unable to uninstall old override: %s'), $e->getMessage()));
        //$this->uninstallOverrides(); remove this line because if module a install an override, then module b install same override, this line will remove override of module a (if you find a bug related to this line please don't forget what i say before)
        return false;
    }
    // Install overrides
    try {
        $object->installOverrides();
    } catch (Exception $e) {
        $object->add_error(sprintf(Tools::displayError('Unable to install override: %s'), $e->getMessage()));
        //$this->uninstallOverrides(); remove this line because if module a install an override, then module b install same override, this line will remove override of module a (if you find a bug related to this line please don't forget what i say before)
        return false;
    }

    if(!Hook::getIdByName('actionBeforeAddOrder')){
        $hook = new Hook();
        $hook->name = 'actionBeforeAddOrder';
        $hook->title = 'New orders before order is added';
        $hook->description = 'Custom hook for PaymentModule ValidateOrder function';
        $hook->position = true;
        $hook->live_edit = false;
        $hook->add();
    }
    $id_new_hook = Hook::getIdByName('actionBeforeAddOrder');
    $id_old_hook = Hook::getIdByName('actionValidateOrder');
    $mod_new_hook = Hook::getModulesFromHook($id_new_hook, $object->id);
    $mod_old_hook = Hook::getModulesFromHook($id_old_hook, $object->id);
    if(empty($mod_new_hook))
        $object->registerHook('actionBeforeAddOrder');
    if(!empty($mod_old_hook))
        $object->unregisterHook('actionValidateOrder');

    return true;
}